﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CommonUtil
{
    /// <summary>
    /// 中国大陆身份证工具
    /// </summary>
    public class CnIdCardUtils
    {
        //生成随机年份
        private static int GenerateYear()
        {
            StringBuilder bu = new StringBuilder();
            Random rd = new Random();
            int year = rd.Next(1960, 2000);
            bu.Append(year);
            return int.Parse(bu.ToString());
        }
   
        /// <summary>
        /// 生成随机身份证号
        /// </summary>
        /// <param name="cityCode"></param>
        /// <returns></returns>
        public static string Generate(int cityCode)
        {
            StringBuilder bu = new StringBuilder();
            Random rd = new Random();
            bu.Append(cityCode);
            int year = GenerateYear();
            bu.Append(year);
            int month = rd.Next(1, 12);
            if (month < 10)
            {
                bu.Append(0);
            }
            bu.Append(month);
            int[] days;
            if (Isleapyear(year))
            {
                days = new int[12] { 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
            }
            else
            {
                days = new int[12] { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
            }

            int day = rd.Next(1, days[month]);
            if (day < 10)
            {
                bu.Append(0);
            }
            bu.Append(day);
            bu.Append(RandomCode());
            int[] c = { 7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2 };
            char[] r = { '1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2' };
            string convert = bu.ToString();

            int it = 0;
            int res = 0;

            while (it < 17)
            {
                res = res + (convert[it] - '0') * c[it];
                it++;
            }


            int i = res % 11;
            bu.Append(r[i]);
            return bu.ToString();
        }

        // 生成3位随机
        private static string RandomCode()
        {
            StringBuilder bu = new StringBuilder();
            Random rd = new Random();
            int code = rd.Next(1, 999);
            if (code < 10)
            {
                bu.Append(00);
            }
            else if (code < 100)
            {
                bu.Append(0);
            }
            bu.Append(code);
            return bu.ToString();
        }

        private static bool Isleapyear(int year)
        {
            if (year % 4 == 0)
            {
                if (year % 100 == 0 && year % 400 != 0)
                {
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}
