﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CommonUtil
{
    public class DateTimeUtils
    {
        /// <summary>
        /// 获取当前秒时间戳 
        /// </summary>
        /// <returns></returns>
        public static long GetTimeStampOfSecond()
        {
            TimeSpan ts = DateTime.Now - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalSeconds);
        }

        /// <summary>
        /// 获取当前毫秒时间戳 
        /// </summary>
        /// <returns></returns>
        public static long GetTimeStampOfMilliseconds()
        {
            TimeSpan ts = DateTime.UtcNow - new DateTime(1970, 1, 1, 0, 0, 0, 0);
            return Convert.ToInt64(ts.TotalMilliseconds);
        }

        /// <summary>        
        /// 将Unix时间戳转为C#时间格式      
        /// </summary>
        /// <param name="timeSpan"></param>        
        /// <returns></returns>        
        public static DateTime GetDateTimeFromUnix(long timeSpan)
        {
            DateTime dtStart = TimeZone.CurrentTimeZone.ToLocalTime(new DateTime(1970, 1, 1));
            long lTime = long.Parse(timeSpan + "0000");
            TimeSpan toNow = new TimeSpan(lTime);
            return dtStart.Add(toNow);
        }
    }
}
