﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CommonUtil
{
    public class StringUtils
    {
        private static Random Random = new Random();

        public static bool IsDigital(string str)
        {
            if (string.IsNullOrWhiteSpace(str))
            {
                return false;
            }
            foreach(char c in str)
            {
                if (c < 48 || c > 57)
                    return false;
            }
            return true;
        }

        /// <summary>
        /// 获取随机手机号
        /// </summary>
        /// <returns></returns>
        public static string GenerateRandomPhone()
        {

            String[] Top3 = {"133", "149", "153", "173", "177",
                "180", "181", "189", "199", "130", "131", "132",
                "145", "155", "156", "166", "171", "175", "176", "185", "186", "166", "134", "135",
                "136", "137", "138", "139", "147", "150", "151", "152", "157", "158", "159", "172",
                "178", "182", "183", "184", "187", "188", "198", "170", "171"};

            int index = Random.Next(0, Top3.Length);

            //随机出真实号段   使用数组的length属性，获得数组长度，
            //通过Math.random（）*数组长度获得数组下标，从而随机出前三位的号段
            String firstNum = Top3[index];
            //随机出剩下的8位数
            String lastNum = "";
            int last = 8;
            for (int i = 0; i < last; i++)
            {
                //每次循环都从0~9挑选一个随机数
                lastNum += Random.Next(0, 10);
            }
            //最终将号段和尾数连接起来
            return firstNum + lastNum;
        }

        /// <summary>
        /// 生成随机IP
        /// </summary>
        /// <returns></returns>
        public static string GenerateRandomIp()
        {     /*
     int[][]
     这个叫交错数组,白话文就是数组的数组.
    初始化的方法:
     int[][] numbers = new int[][] { new int[] {2,3,4}, new int[] {5,6,7,8,9} };
当然也可以使用{}初始化器初始化
             int[][] numbers = { new int[] {2,3,4}, 
                            new int[] {5,6,7,8,9} 
                          };
     */
            int[][] range = {new int[]{607649792,608174079},//36.56.0.0-36.63.255.255
new int[]{1038614528,1039007743},//61.232.0.0-61.237.255.255
new int[]{1783627776,1784676351},//106.80.0.0-106.95.255.255
new int[]{2035023872,2035154943},//121.76.0.0-121.77.255.255
new int[]{2078801920,2079064063},//123.232.0.0-123.235.255.255
new int[]{-1950089216,-1948778497},//139.196.0.0-139.215.255.255
new int[]{-1425539072,-1425014785},//171.8.0.0-171.15.255.255
new int[]{-1236271104,-1235419137},//182.80.0.0-182.92.255.255
new int[]{-770113536,-768606209},//210.25.0.0-210.47.255.255
 new int[]{-569376768,-564133889}, //222.16.0.0-222.95.255.255
};

            int index = Random.Next(10);
            string ip = num2ip(range[index][0] + Random.Next(range[index][1] - range[index][0]));
            return ip;
        }

        /*
         * 将十进制转换成ip地址
        */
        private static string num2ip(int ip)
        {
            int[] b = new int[4];
            string x = "";
            //位移然后与255 做高低位转换
            b[0] = (int)((ip >> 24) & 0xff);
            b[1] = (int)((ip >> 16) & 0xff);
            b[2] = (int)((ip >> 8) & 0xff);
            b[3] = (int)(ip & 0xff);
            x = (b[0]).ToString() + "." + (b[1]).ToString() + "." + (b[2]).ToString() + "." + (b[3]).ToString();

            return x;
        }

    }
}
