﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CommonUtil
{
    public class UILogUtils
    {
        private static readonly List<IUILog> UI_LOGS = new List<IUILog>();

        public static void Add(IUILog uILog)
        {
            UI_LOGS.Add(uILog);
        }

        public static void Debug(String message)
        {
            foreach (IUILog log in UI_LOGS)
            {
                log.Debug(message);
            }
        }

        public static void Info(String message)
        {
            foreach (IUILog log in UI_LOGS)
            {
                log.Info(message);
            }
        }


        public static void Error(String message)
        {
            foreach (IUILog log in UI_LOGS)
            {
                log.Error(message);
            }
        }

        public static void Error(Exception exception)
        {
            foreach (IUILog log in UI_LOGS)
            {
                log.Error(exception);
            }
        }

        public static void Error(String message, Exception exception)
        {
            foreach (IUILog log in UI_LOGS)
            {
                log.Error(message, exception);
            }
        }
    }
}
