﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web;

namespace CommonUtil
{
    public class UrlUtils
    {
        public static string BuildQueryStringUrl(object obj)
        {
            var objJson = JsonConvert.SerializeObject(obj);
            var keyValuePairs = JsonConvert.DeserializeObject<Dictionary<string, Object>>(objJson);

            return BuildQueryStringUrl(keyValuePairs);
        }

        public static string BuildQueryStringUrl(Dictionary<string, Object> keyValuePairs)
        {
            if (keyValuePairs == null || keyValuePairs.Count <= 0)
            {
                return null;
            }

            StringBuilder stringBuilder = new StringBuilder();
            foreach (KeyValuePair<string, Object> keyValue in keyValuePairs)
            {
                if (keyValue.Value != null)
                {
                    if (keyValue.Value is bool)
                    {
                        stringBuilder.Append($"{keyValue.Key}=" + (((bool)(keyValue.Value)) ? "true" : "false") + "&");
                    }
                    else
                    {
                        stringBuilder.Append($"{keyValue.Key}={HttpUtility.UrlEncode(keyValue.Value.ToString())}&");
                    }

                }
                else
                {
                    stringBuilder.Append($"{keyValue.Key}=&");
                }

            }
            return stringBuilder.ToString();
        }

        /// <summary>
        /// 解析url参数
        /// </summary>
        /// <param name="url"></param>
        /// <returns></returns>
        public static Dictionary<String, String> ParseUrlParams(String url)
        {
            Dictionary<String, String> result = new Dictionary<string, string>();
            if (string.IsNullOrWhiteSpace(url))
            {
                return result;
            }

            int index = url.IndexOf('?');
            if (index < 0)
            {
                return result;
            }

            String paramString = url.Substring(index + 1);
            var paramList = paramString.Split(new char[] { '&' }, StringSplitOptions.RemoveEmptyEntries).ToList();
            if (paramList.Count <= 0)
            {
                return result;
            }

            foreach (String param in paramList)
            {
                var paramItemArray = param.Split(new char[] { '=' }, StringSplitOptions.RemoveEmptyEntries);
                if (paramItemArray.Length <= 0)
                {
                    continue;
                }
                result.Add(paramItemArray[0], paramItemArray.Length > 1 ? paramItemArray[1] : null);
            }

            return result;
        }
    }
}
