﻿using CommonUtil;
using DingDingSdk.Model;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DingDingSdk
{
    public class DingDingClient
    {
        /// <summary>
        /// 异步发送文本信息
        /// </summary>
        /// <param name="webHookUrl">webhook的url地址</param>
        /// <param name="message">文本内容</param>
        /// <param name="AtMobiles">@的手机号列表</param>
        /// <param name="isAtAll">是否@所有人</param>
        /// <returns></returns>
        public static SendResult SendMessage(string webHookUrl, string message, List<string> AtMobiles = null, bool isAtAll = false)
        {
            if (string.IsNullOrWhiteSpace(message) || string.IsNullOrEmpty(webHookUrl))
            {
                return new SendResult
                {
                    ErrMsg = "参数不正确",
                    ErrCode = -1
                };
            }
            var msg = new TextMessage
            {
                Text = new Text()
                {
                    Content = message
                },
                at = new AtSetting()
            };
            if (AtMobiles != null)
            {
                msg.at.AtMobiles = AtMobiles;
                msg.at.IsAtAll = false;
            }
            else
            {
                if (isAtAll) msg.at.IsAtAll = true;
            }

            var json = msg.ToJson();
            return Send(webHookUrl, json);
        }


        /// <summary>
        /// 异步发送其他类型的信息
        /// </summary>
        /// <param name="webHookUrl">webhook的url地址</param>
        /// <param name="message">信息model</param>
        /// <returns></returns>
        public static SendResult SendMessage(string webHookUrl, IDingDingMessage message)
        {
            if (message == null || string.IsNullOrEmpty(webHookUrl))
            {
                return new SendResult
                {
                    ErrMsg = "参数不正确",
                    ErrCode = -1
                };
            }
            var json = message.ToJson();
            return Send(webHookUrl, json);
        }


        /// <summary>
        /// 发送
        /// </summary>
        /// <param name="webHookUrl"></param>
        /// <param name="data"></param>
        /// <returns></returns>
        private static SendResult Send(string webHookUrl, string data)
        {
            try
            {
                var responseStr = HttpUtils.DoPost(webHookUrl, data, null);

                return JsonConvert.DeserializeObject<SendResult>(responseStr);
            }
            catch (Exception ex)
            {
                return new SendResult { ErrMsg = ex.Message, ErrCode = -1 };
            }
        }
    }
}
