﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace DingDingSdk.Model
{
    public class TextMessage : DingDingMessage
    {

        [JsonProperty("msgtype")]
        public  string MessageType { get; set; } = "text";

        /// <summary>
        /// 消息内容
        /// </summary>
        [JsonProperty("text")]
        public Text Text { get; set; }

        /// <summary>
        /// 被@的信息
        /// </summary>
        [JsonProperty("at")]
        public AtSetting at { get; set; }
    }

    public class Text
    {
        /// <summary>
        /// 消息内容
        /// </summary>
        [JsonProperty("content")]
        public string Content { get; set; }
    }

    /// <summary>
    /// @ 配置
    /// </summary>
    public class AtSetting
    {
        public AtSetting()
        {
            AtMobiles = new List<string>();
        }

        /// <summary>
        /// 被@人的手机号
        /// </summary>
        [JsonProperty("atMobiles")]
        public List<string> AtMobiles { get; set; }

        /// <summary>
        /// @所有人时:true,否则为:false
        /// </summary>
        [JsonProperty("isAtAll")]
        public bool IsAtAll { get; set; }

    }
}
