﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using iqiyiWin.Constant;
using iqiyiWin.Model;
using iqiyiWin.Response.User.CouponList;
using iqiyiWin.Response.User.LockDraw;
using iqiyiWin.Response.User.MovieBean;
using iqiyiWin.Util;
using Newtonsoft.Json;

namespace iqiyiWin.Api
{
    public class User
    {
        private static Random NonceRandom = new Random();
        /// <summary>
        /// 查询观影豆
        /// </summary>
        /// <param name="cookie"></param>
        /// <returns></returns>
        public  static string GetMovieBean(IqiyiAccount iqiyiAccount)
        {
            var headers = new SortedDictionary<string, string>();

            headers.Add("version", IqiyiVersion.Version);
            headers.Add("os", IqiyiVersion.Os);
            headers.Add("src", IqiyiVersion.Src);
            headers.Add("platform", IqiyiVersion.Platform);
            headers.Add("appid", IqiyiVersion.Appid);
            headers.Add("dvsrc", IqiyiVersion.Dvsrc);
            headers.Add("dfp", IqiyiVersion.Dfp());
            headers.Add("ts", DateUtils.GetTimeStampOfMilliseconds().ToString());
            headers.Add("nonce", IqiyiVersion.Nonce());
            headers.Add("pageNo", "0");
            headers.Add("pageCount", "20");
            headers.Add("ck", iqiyiAccount.Cookie);

            headers.Add("sig", IqiyiSign.Sign(headers));

            var cookieContainer = new CookieContainer();
            var cookieItem = new Cookie();
            cookieItem.Name = "P00001";
            cookieItem.Value = iqiyiAccount.Cookie;
            cookieItem.Domain = ".iqiyi.com";
            cookieContainer.Add(cookieItem);

            var queryText = UrlUtils.BuildQueryStringUrl(headers);

            var responseStr = HttpUtils.DoGet(cookieContainer, Domain.REFERER_DOMAIN, Domain.TICKET_IQIYI + ApiConstant.GET_MOVIE_BEAN + queryText, headers);

            var response = JsonConvert.DeserializeObject<MovieBeanResponse>(responseStr);

            if (response != null && response.Code == "A00000")
            {
                // UILogUtils.Info($"爱奇艺票务 【获取观影豆】成功: {iqiyiAccount.MobileNo} [当前观影豆：{response.Data.BalanceCount}]");
                return response.Data.BalanceCount.ToString();
            }
            else
            {
                // UILogUtils.Error($"爱奇艺票务 【获取观影豆】失败:  {iqiyiAccount.MobileNo} {(response == null ? responseStr : response.Msg)}");
                return "-1";
            }
        }
        /// <summary>
        /// 获取优惠券
        /// </summary>
        /// <param name="iqiyiAccount"></param>
        /// <returns></returns>
        public static List<Valid> GetCouponList(IqiyiAccount iqiyiAccount)
        {
            var headers = new SortedDictionary<string, string>();

            headers.Add("version", IqiyiVersion.Version);
            headers.Add("os", IqiyiVersion.Os);
            headers.Add("src", IqiyiVersion.Src);
            headers.Add("platform", IqiyiVersion.Platform);
            headers.Add("appid", IqiyiVersion.Appid);
            headers.Add("dvsrc", IqiyiVersion.Dvsrc);
            headers.Add("dfp", IqiyiVersion.Dfp());
            headers.Add("ts", DateUtils.GetTimeStampOfMilliseconds().ToString());
            headers.Add("nonce", IqiyiVersion.Nonce());
            headers.Add("pageNo", "0");
            headers.Add("pageCount", "20");
            headers.Add("ck", iqiyiAccount.Cookie);

            headers.Add("sig", IqiyiSign.Sign(headers));

            var cookieContainer = new CookieContainer();
            var cookieItem = new Cookie();
            cookieItem.Name = "P00001";
            cookieItem.Value = iqiyiAccount.Cookie;
            cookieItem.Domain = ".iqiyi.com";
            cookieContainer.Add(cookieItem);

            var queryText = UrlUtils.BuildQueryStringUrl(headers);

            var responseStr = HttpUtils.DoGet(cookieContainer, Domain.REFERER_DOMAIN, Domain.TICKET_IQIYI + ApiConstant.GET_COUPON_LIST + queryText, headers);

            var response = JsonConvert.DeserializeObject<CouponListResponse>(responseStr);

            if (response != null && response.Code == "A00000")
            {
                var couponTextList =new List<string>();
                foreach(Valid item in response.Data.Valid)
                {
                    couponTextList.Add($"                  {item.DisplayName}-{item.DisCountStr}-{item.AvailableTips}");
                };
                // UILogUtils.Info($"爱奇艺票务 【获取优惠券数量】成功: {iqiyiAccount.MobileNo} [当前优惠券数量：{response.Data.Valid.Count}]\n{ string.Join("\n", couponTextList.ToArray())}");
                return response.Data.Valid;
            }
            else
            {
                // UILogUtils.Error($"爱奇艺票务 【获取优惠券数量】失败: {iqiyiAccount.MobileNo} {(response == null ? responseStr : response.Msg)}");
                return null;
            }
        }
        /// <summary>
        /// 签到
        /// </summary>
        /// <param name="iqiyiAccount"></param>
        /// <returns></returns>
        public static Boolean UserDoSign(IqiyiAccount iqiyiAccount)
        {
            var headers = new SortedDictionary<string, string>();

            var dfp = IqiyiVersion.Dfp();

            //headers.Add("deviceId", dfp);
            //headers.Add("dfp", dfp);
            //headers.Add("appid", "1003");
            //headers.Add("os", "CPU iPhone OS 13_2_3 like Mac OS X");
            //headers.Add("format", "json");
            //headers.Add("platform", "Win32");
            //headers.Add("ts", DateUtils.GetTimeStampOfMilliseconds().ToString());
            //headers.Add("src", "H5");
            //headers.Add("version", "1.0.0");
            //headers.Add("ck", iqiyiAccount.Cookie);
            //headers.Add("nonce", $"0.{NonceRandom.Next(10000000, 99999999)}{NonceRandom.Next(10000000, 99999999)}");
            //headers.Add("bizType", "APP");
            //headers.Add("_t", DateUtils.GetTimeStampOfMilliseconds().ToString());

            headers.Add("deviceId", dfp);
            headers.Add("dfp", dfp);
            headers.Add("appid", "10010");
            headers.Add("os", "14.4");
            headers.Add("format", "json");
            headers.Add("platform", "iphone");
            headers.Add("ts", DateUtils.GetTimeStampOfMilliseconds().ToString());
            headers.Add("location", "");
            headers.Add("src", "ios");
            headers.Add("version", "3.3.0");
            headers.Add("ck", iqiyiAccount.Cookie);
            headers.Add("nonce", "1248907070");
            headers.Add("bizType", "APP");
            headers.Add("_t", DateUtils.GetTimeStampOfMilliseconds().ToString());
            headers.Add("cityId", "");

            var queryText = UrlUtils.BuildQueryStringUrl(headers);

            var responseStr = HttpUtils.DoGet(Domain.TICKET_IQIYI + ApiConstant.USER_SIGN_IN + queryText, headers);

            var response = JsonConvert.DeserializeObject<CouponListResponse>(responseStr);

            if (response != null && (response.Code == "A00000" || response.Code == "A00001"))
            {
                // UILogUtils.Info($"爱奇艺票务 【签到】成功: {iqiyiAccount.MobileNo}");
                return true;
            }
            else
            {
                // UILogUtils.Error($"爱奇艺票务 【签到】失败: {iqiyiAccount.MobileNo} {(response == null ? responseStr : response.Msg)}");
                return false;
            }
        }
        /// <summary>
        /// 抽奖
        /// </summary>
        /// <param name="iqiyiAccount"></param>
        public static LockDrawResponse LockDarw(IqiyiAccount iqiyiAccount,string actCode)
        {

            var headers = new SortedDictionary<string, string>();
            var queryList = new SortedDictionary<string, string>();

            queryList.Add("actCode", actCode);
            queryList.Add("P00001", iqiyiAccount.Cookie);
            headers.Add("Origin", "https://www.iqiyi.com");

            var queryText = UrlUtils.BuildQueryStringUrl(queryList);

            var responseStr = HttpUtils.DoGet(new CookieContainer() , Domain.WWW_IQIYI, Domain.PCELL_DOMAIN + ApiConstant.LOCK_DRAW + queryText, headers);

            var response = JsonConvert.DeserializeObject<LockDrawResponse>(responseStr);

            return response;
            //if (response != null && (response.Code == "A00000"))
            //{
            //    // UILogUtils.Info($"爱奇艺票务 【签到】成功: {iqiyiAccount.MobileNo}");
            //    return response;
            //}
            //else
            //{
            //    // UILogUtils.Error($"爱奇艺票务 【签到】失败: {iqiyiAccount.MobileNo} {(response == null ? responseStr : response.Msg)}");
            //    return null;
            //}
        }
    }
}
