﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using iqiyiWin.Api;
using iqiyiWin.Model;
using iqiyiWin.Util;
using iqiyiWin.Constant;
using System.Threading;
using System.Collections;
using System.IO;
using DingDingSdk;
using iqiyiWin.Enums;
using iqiyiWin.Extension;

namespace iqiyiWin
{
    public partial class Main : Form, IUILog
    {
        /// <summary>
        /// 当前窗体
        /// </summary>
        public static Main _this = null;
        /// <summary>
        /// 是否调试
        /// </summary>
        public static Boolean isDebuger = false;
        /// <summary>
        /// 线程idset
        /// </summary>
        private HashSet<int> _threadIdSet = new HashSet<int>();
        /// <summary>
        /// 爱奇艺账号列表
        /// </summary>
        public List<IqiyiAccount> IqiyiAccounts = new List<IqiyiAccount>();
        /// <summary>
        /// 选中数量
        /// </summary>
        public static int SelectNum = 0;
        /// <summary>
        /// 执行数量
        /// </summary>
        public static int ImplementNum = 0;
        /// <summary>
        /// 成功数量
        /// </summary>
        public static int SuccessNum = 0;
        /// <summary>
        /// 失败数量
        /// </summary>
        public static int ErrorNum = 0;
        /// <summary>
        /// 等待数量
        /// </summary>
        public static int WaitNum = 0;
        /// <summary>
        /// 取消操作通知
        /// </summary>
        private CancellationTokenSource _cancellationTokenSource;
        /// <summary>
        /// 程序运行状态
        /// </summary>
        public Boolean IsLoading = false;
        /// <summary>
        /// 程序执行任务的开始时间
        /// </summary>
        public long StartTime = 0;
        /// <summary>
        /// 程序执行任务的完成时间
        /// </summary>
        public long EndTime = 0;
        /// <summary>
        /// 程序执行多久之后可以被重新启动
        /// </summary>
        public long TimeAbnormalInterval = 12 * 60 * 60  * 1000;
        /// <summary>
        /// 设置准时的定时任务
        /// </summary>
        private System.Windows.Forms.Timer TimerSetOnTime = new System.Windows.Forms.Timer();
        /// <summary>
        /// 定时任务的倒计时
        /// </summary>
        private System.Windows.Forms.Timer TimerTiming = new System.Windows.Forms.Timer();
        /// <summary>
        /// 默认定时任务的时间
        /// </summary>
        public int IntervalTime = 12 * 60 * 60 ;
        /// <summary>
        /// 等待执行的任务列表
        /// </summary>
        public List<TaskTypeEnum> TaskList = new List<TaskTypeEnum>();
        /// <summary>
        /// 当前执行的任务下标
        /// </summary>
        public int TaskIndex = -1;
        /// <summary>
        /// 抽奖id
        /// </summary>
        public string ActCode = "";

        public Main()
        {
            InitializeComponent();

            this.init();

            _this = this;
        }

        public void init()
        {
            UILogUtils.Add(this);

            dgv_user.AutoGenerateColumns = false;
        }


        private void Form1_Load(object sender, EventArgs e)
        {
        }

        #region 右键导入账号
        /// <summary>
        /// 右键导入账号
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void 导入账号ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                var dataObject = Clipboard.GetDataObject();
                if (dataObject.GetDataPresent(DataFormats.Text))
                {
                    string text = (String)dataObject.GetData(DataFormats.Text);

                    var iqiyiAccounts = Text2IqiyiAccounts(text);

                    AddIqiyiAccount(iqiyiAccounts);
                }
                else
                {
                    UILogUtils.Error("粘贴板没有文本数据。");
                }
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }
        private List<IqiyiAccount> Text2IqiyiAccounts(string text)
        {
            var iqiyiAccounts = new List<IqiyiAccount>();
            var lines = text.Split(new String[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries).ToList();
            lines.ForEach(line =>
            {
                var optionItems = line.Split(new String[] { "----" }, StringSplitOptions.RemoveEmptyEntries);
                if (optionItems == null)
                {
                    throw new Exception("行:" + line + "格式不正确[1]。");
                }

                string version = optionItems[0];
                if (optionItems.Length != 3)
                {
                    throw new Exception("行:" + line + "格式不正确[2]。");
                }
                var iqiyiAccount = new IqiyiAccount()
                {
                    MobileNo = optionItems[0],
                    Password = optionItems[1],
                    Cookie = optionItems[2]
                };
                iqiyiAccounts.Add(iqiyiAccount);

            });
            return iqiyiAccounts;
        }
        /// <summary>
        /// 添加爱奇艺账号
        /// </summary>
        private void AddIqiyiAccount(List<IqiyiAccount> iqiyiAccounts)
        {

            if (iqiyiAccounts == null || iqiyiAccounts.Count < 0)
            {
                return;
            }

            int index = 1;
            iqiyiAccounts.ForEach(x =>
            {
                x.No = index++;
            });
            IqiyiAccounts.AddRange(iqiyiAccounts);
            RefreshIqiyiAccount();
        }
        private void RefreshIqiyiAccount()
        {
            dgv_user.DataSource = null;
            dgv_user.DataSource = IqiyiAccounts;
        }
        #endregion
        #region 设置界面数量
        public void setStatusStripNum()
        {
            if (this.InvokeRequired)
            {
                this.Invoke(new Action(setStatusStripNumNext));
            }
            else
            {
                setStatusStripNumNext();
            }
        }

        private void setStatusStripNumNext()
        {
            tssl_select_num.Text = SelectNum.ToString();
            tssl_implement_num.Text = ImplementNum.ToString();
            tssl_success_num.Text = SuccessNum.ToString();
            tssl_error_num.Text = ErrorNum.ToString();
            tssl_wait_num.Text = WaitNum.ToString();

            if (SelectNum == ImplementNum)
            {
                IsLoading = false;
                EndTime = DateUtils.GetTimeStampOfMilliseconds();
                var hour = Convert.ToInt32((EndTime - StartTime) / (1000 * 60 * 60));
                var mominute = Convert.ToInt32(((EndTime - StartTime) % (1000 * 60 * 60)) / (1000 * 60));
                var msecond = ((EndTime - StartTime) % (1000 * 60) / 1000);

                var logText = $"爱奇艺票务 本次{EnumExtension.GetDescription(TaskList[TaskIndex])}任务，共计执行{SelectNum}个账号,成功{SuccessNum}个账号，失败{ErrorNum}个账号，所用时长{hour}小时{mominute}分钟{msecond}秒钟。";

                // 如果它是查券就进行排序
                if (TaskList[TaskIndex] == TaskTypeEnum.Coupon)
                {
                    var hasCouponAccount = new List<IqiyiAccount>();
                    foreach (var item in IqiyiAccounts)
                    {
                        if(item.CouponList != null && item.CouponList.Count > 0)
                        {
                            hasCouponAccount.Add(item);
                        }
                    }

                    String fileNamePrefix = "查询优惠券成功有券排序完成-" + DateTime.Now.ToString("HHmmss") + ".txt";
                    var fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志", "查询优惠券", DateTime.Now.ToString("yyyyMMdd"));
                    var filePath = Path.Combine(fileDirectory, fileNamePrefix);
                    var fileText = "";

                    for (int i = 0; i < hasCouponAccount.Count; i++)
                    {
                        for (int j = i +1; j < hasCouponAccount.Count; j++)
                        {
                            if(hasCouponAccount[i].CouponList[0].ExpiredTimeNum > hasCouponAccount[j].CouponList[0].ExpiredTimeNum)
                            {
                                var temp = hasCouponAccount[i];
                                hasCouponAccount[i] = hasCouponAccount[j];
                                hasCouponAccount[j] = temp;
                            }
                        }
                        var item = hasCouponAccount[i];
                        fileText = $"{item.MobileNo}----{item.Password}----{item.Cookie}|";
                        foreach (var v in item.CouponList)
                        {
                            fileText += $"[{v.DisplaySubType}|{v.DisplaySubName}~减{v.DisCountStr}|{v.AvailableTips}]";
                        }
                        fileText += $"\n";
                        FileUtils.AppendAllText(filePath, fileText, Encoding.UTF8);
                    }
                }

                if (TimerTiming.Enabled)
                {
                    SendDingdingMessagesAsync($"{logText}", "18057708086");
                }
                else
                {
                    UILogUtils.Info($"{logText}");
                }

                if(TaskIndex < TaskList.Count - 1 && TaskIndex != -1)
                {
                    Interlocked.Increment(ref TaskIndex);
                    runTask();
                }
                else
                {
                    TaskIndex = -1;
                    if (TimerTiming.Enabled)
                    {
                        var taskNameList = new List<string>();
                        foreach(var item in TaskList)
                        {
                            taskNameList.Add(EnumExtension.GetDescription(item));
                        }
                        SendDingdingMessagesAsync($"爱奇艺票务 每日任务[{string.Join(" , ", taskNameList.ToArray())}]执行完毕。", "18057708086");
                    }
                }
            }
            
        }
        #endregion
        #region 界面日志

        public void Info(string message)
        {
            message = string.Format("[信息] [{0}] {1} {2}", DateTime.Now.ToString("HH:mm:ss"), message, Environment.NewLine);

            if (txtLog.InvokeRequired)
            {
                txtLog.Invoke(new Action<String>(ShowInfoMessage), new object[] { message });
            }
            else
            {
                ShowInfoMessage(message);
            }
        }

        private void ShowInfoMessage(string message)
        {
            txtLog.AppendText(message);
            // 将光标位置设置到当前内容的末尾
            txtLog.SelectionStart = txtLog.Text.Length;
            // 滚动到光标位置
            txtLog.ScrollToCaret();
        }

        public void Error(string message)
        {
            message = string.Format("[错误] [{0}] {1} {2}", DateTime.Now.ToString("HH:mm:ss"), message, Environment.NewLine);

            if (txtLog.InvokeRequired)
            {
                txtLog.Invoke(new Action<String>(ShowErrorMessage), new object[] { message });
            }
            else
            {
                ShowErrorMessage(message);
            }
        }

        public void Error(Exception exception)
        {
            String message = string.Format("[信息] [{0}] {1} {2}", DateTime.Now.ToString("HH:mm:ss"),
                isDebuger ? exception.ToString() : exception.Message, Environment.NewLine);

            if (txtLog.InvokeRequired)
            {
                txtLog.Invoke(new Action<String>(ShowErrorMessage), new object[] { message });
            }
            else
            {
                ShowErrorMessage(message);
            }
        }

        public void Error(string message, Exception exception)
        {
            Error(message);
            Error(exception);
        }

        private void ShowErrorMessage(string message)
        {
            txtLog.SelectionStart = txtLog.TextLength;
            txtLog.SelectionLength = 0;
            txtLog.SelectionColor = Color.Red;
            txtLog.AppendText(message);
            txtLog.SelectionColor = txtLog.ForeColor;
            //将光标位置设置到当前内容的末尾
            txtLog.SelectionStart = txtLog.Text.Length;
            //滚动到光标位置
            txtLog.ScrollToCaret();
        }

        public void Debug(string message)
        {
            if (!isDebuger)
            {
                return;
            }

            message = string.Format("[调试] [{0}] {1} {2}", DateTime.Now.ToString("HH:mm:ss"), message, Environment.NewLine);

            if (txtLog.InvokeRequired)
            {
                txtLog.Invoke(new Action<String>(ShowDebugMessage), new object[] { message });
            }
            else
            {
                ShowDebugMessage(message);
            }
        }
        private void ShowDebugMessage(string message)
        {
            txtLog.SelectionStart = txtLog.TextLength;
            txtLog.SelectionLength = 0;
            txtLog.SelectionColor = Color.Blue;
            txtLog.AppendText(message);
            txtLog.SelectionColor = txtLog.ForeColor;
            //将光标位置设置到当前内容的末尾
            txtLog.SelectionStart = txtLog.Text.Length;
            //滚动到光标位置
            txtLog.ScrollToCaret();
        }
        #endregion
        #region 签到
        private void 签到ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (DateUtils.GetTimeStampOfMilliseconds() - StartTime > TimeAbnormalInterval)
                {
                    IsLoading = false;
                }
                if (IsLoading  )
                {
                    return;
                }
                if (dgv_user.SelectedRows == null || dgv_user.SelectedRows.Count <= 0)
                {
                    UILogUtils.Error("请选择要签到的账号。");
                    return;
                }

                var iqiyiAccounts = new List<IqiyiAccount>();

                foreach (DataGridViewRow row in dgv_user.SelectedRows)
                {
                    IqiyiAccount iqiyiAccount = row.DataBoundItem as IqiyiAccount;
                    iqiyiAccounts.Add(iqiyiAccount);
                }

                IsLoading = true;

                TaskList = new List<TaskTypeEnum>{
                    TaskTypeEnum.SignIn
                };

                TaskIndex = 0;

                AccountSignIn(iqiyiAccounts);

            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }
        public void AccountSignIn(List<IqiyiAccount> iqiyiAccounts)
        {
            StartTime = DateUtils.GetTimeStampOfMilliseconds();
            SelectNum = iqiyiAccounts.Count;
            ImplementNum = 0;
            SuccessNum = 0;
            ErrorNum = 0;
            WaitNum = iqiyiAccounts.Count;
            setStatusStripNum();

            _cancellationTokenSource?.Cancel();
            _cancellationTokenSource = new CancellationTokenSource();
            CancellationToken cancellationToken = _cancellationTokenSource.Token;

            String fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志","签到", DateTime.Now.ToString("yyyyMMdd"));
            String fileNamePrefixSuccess = "签到成功-" + DateTime.Now.ToString("HHmmss") + ".txt";
            String fileNamePrefixError = "签到失败-" + DateTime.Now.ToString("HHmmss") + ".txt";

            foreach (var iqiyiAccount in iqiyiAccounts)
            {
                Task.Factory.StartNew(() =>
                {
                    int threadId = Thread.CurrentThread.ManagedThreadId;
                    if (!_threadIdSet.Contains(threadId))
                    {
                        _threadIdSet.Add(threadId);
                        UILogUtils.Info($"线程[{threadId}]运行中...总线程数[{_threadIdSet.Count}]");
                    }

                    string filePath = "";
                    string fileText = $"{iqiyiAccount.MobileNo}----{iqiyiAccount.Password}----{iqiyiAccount.Cookie}\n";
                    if (User.UserDoSign(iqiyiAccount))
                    {
                        iqiyiAccount.SignStatus = 1;
                        iqiyiAccount.SignStatusDesc = "签到成功";

                        Interlocked.Increment(ref SuccessNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        filePath = Path.Combine(fileDirectory, fileNamePrefixSuccess);
                    }
                    else
                    {
                        iqiyiAccount.SignStatus = 2;
                        iqiyiAccount.SignStatusDesc = "签到错误";
                        Interlocked.Increment(ref ErrorNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        filePath = Path.Combine(fileDirectory, fileNamePrefixError);
                    }
                    setStatusStripNum();

                    FileUtils.AppendAllText(filePath, fileText , Encoding.UTF8);

                },  cancellationToken);
            }
        }
        #endregion
        #region 查询观影豆
        private void 查询观影豆ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {

                if (dgv_user.SelectedRows == null || dgv_user.SelectedRows.Count <= 0)
                {
                    UILogUtils.Error("请选择要查询的账号。");
                    return;
                }

                if (DateUtils.GetTimeStampOfMilliseconds() - StartTime > TimeAbnormalInterval)
                {
                    IsLoading = false;
                }
                if (IsLoading)
                {
                    return;
                }

                var iqiyiAccounts = new List<IqiyiAccount>();
                foreach (DataGridViewRow row in dgv_user.SelectedRows)
                {
                    IqiyiAccount iqiyiAccount = row.DataBoundItem as IqiyiAccount;
                    iqiyiAccounts.Add(iqiyiAccount);
                }

                IsLoading = true;

                TaskList = new List<TaskTypeEnum>{
                    TaskTypeEnum.MovieBean
                };

                TaskIndex = 0;

                queryMovieBean(iqiyiAccounts);
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }
        public void queryMovieBean(List<IqiyiAccount> iqiyiAccounts)
        {
            StartTime = DateUtils.GetTimeStampOfMilliseconds();

            SelectNum = iqiyiAccounts.Count;
            ImplementNum = 0;
            SuccessNum = 0;
            ErrorNum = 0;
            WaitNum = iqiyiAccounts.Count;
            setStatusStripNum();

            _cancellationTokenSource?.Cancel();
            _cancellationTokenSource = new CancellationTokenSource();
            CancellationToken cancellationToken = _cancellationTokenSource.Token;

            String fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志","查询观影豆", DateTime.Now.ToString("yyyyMMdd"));
            String fileNamePrefixSuccess = "查询观影豆成功-" + DateTime.Now.ToString("HHmmss") + ".txt";
            String fileNamePrefixError = "查询观影豆失败-" + DateTime.Now.ToString("HHmmss") + ".txt";

            foreach (var iqiyiAccount in iqiyiAccounts)
            {
                Task.Factory.StartNew(() =>
                {
                    int threadId = Thread.CurrentThread.ManagedThreadId;
                    if (!_threadIdSet.Contains(threadId))
                    {
                        _threadIdSet.Add(threadId);
                        UILogUtils.Info($"线程[{threadId}]运行中...总线程数[{_threadIdSet.Count}]");
                    }

                    string filePath = "";

                    var iqiyiAccountMovieBean = User.GetMovieBean(iqiyiAccount);

                    iqiyiAccount.MovieBean = Convert.ToInt32(iqiyiAccountMovieBean);

                    if (iqiyiAccountMovieBean == "-1")
                    {
                        Interlocked.Increment(ref ErrorNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        filePath = Path.Combine(fileDirectory, fileNamePrefixError);
                    }
                    else
                    {
                        Interlocked.Increment(ref SuccessNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        filePath = Path.Combine(fileDirectory, fileNamePrefixSuccess);
                    }

                    setStatusStripNum();


                    string fileText = $"{iqiyiAccount.MobileNo}----{iqiyiAccount.Password}----{iqiyiAccount.Cookie}|{iqiyiAccount.MovieBean}\n";
                    FileUtils.AppendAllText(filePath, fileText, Encoding.UTF8);

                }, cancellationToken);
            }
        }
        #endregion
        #region 查询优惠券
        private void 查询优惠券ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv_user.SelectedRows == null || dgv_user.SelectedRows.Count <= 0)
                {
                    UILogUtils.Error("请选择要查询的账号。");
                    return;
                }

                if (DateUtils.GetTimeStampOfMilliseconds() - StartTime > TimeAbnormalInterval)
                {
                    IsLoading = false;
                }
                if (IsLoading)
                {
                    return;
                }

                var iqiyiAccounts = new List<IqiyiAccount>();
                foreach (DataGridViewRow row in dgv_user.SelectedRows)
                {
                    IqiyiAccount iqiyiAccount = row.DataBoundItem as IqiyiAccount;
                    iqiyiAccounts.Add(iqiyiAccount);
                }

                IsLoading = true;

                TaskList = new List<TaskTypeEnum>{
                    TaskTypeEnum.Coupon
                };

                TaskIndex = 0;

                queryCouponNum(iqiyiAccounts);
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }

        public void queryCouponNum(List<IqiyiAccount> iqiyiAccounts)
        {
            StartTime = DateUtils.GetTimeStampOfMilliseconds();

            SelectNum = iqiyiAccounts.Count;
            ImplementNum = 0;
            SuccessNum = 0;
            ErrorNum = 0;
            WaitNum = iqiyiAccounts.Count;
            setStatusStripNum();

            _cancellationTokenSource?.Cancel();
            _cancellationTokenSource = new CancellationTokenSource();
            CancellationToken cancellationToken = _cancellationTokenSource.Token;

            String fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志","查询优惠券", DateTime.Now.ToString("yyyyMMdd"));
            String fileNamePrefixSuccessHasCoupon = "查询优惠券成功有券-" + DateTime.Now.ToString("HHmmss") + ".txt";
            String fileNamePrefixSuccessHasNotCoupon = "查询优惠券成功无券-" + DateTime.Now.ToString("HHmmss") + ".txt";
            String fileNamePrefixError = "查询优惠券失败-" + DateTime.Now.ToString("HHmmss") + ".txt";

            foreach (var iqiyiAccount in iqiyiAccounts)
            {
                Task.Factory.StartNew(() =>
                {
                    int threadId = Thread.CurrentThread.ManagedThreadId;
                    if (!_threadIdSet.Contains(threadId))
                    {
                        _threadIdSet.Add(threadId);
                        UILogUtils.Info($"线程[{threadId}]运行中...总线程数[{_threadIdSet.Count}]");
                    }

                    string filePath = "";

                    var iqiyiAccountCouponList = User.GetCouponList(iqiyiAccount);

                    string fileText = $"{iqiyiAccount.MobileNo}----{iqiyiAccount.Password}----{iqiyiAccount.Cookie}";

                    if (iqiyiAccountCouponList == null)
                    {
                        Interlocked.Increment(ref ErrorNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        filePath = Path.Combine(fileDirectory, fileNamePrefixError);
                        fileText += $"\n";
                    }
                    else if(iqiyiAccountCouponList.Count == 0)
                    {
                        Interlocked.Increment(ref SuccessNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        fileText += $"\n";

                        filePath = Path.Combine(fileDirectory, fileNamePrefixSuccessHasNotCoupon);
                    }
                    else
                    {
                        Interlocked.Increment(ref SuccessNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        iqiyiAccount.CouponList = iqiyiAccountCouponList;

                        iqiyiAccount.CouponNum = Convert.ToInt32(iqiyiAccountCouponList.Count);

                        var couponListText = "";

                        foreach(var item in iqiyiAccountCouponList)
                        {
                            couponListText += $"[{item.DisplaySubType}|{item.DisplaySubName}~减{item.DisCountStr}|{item.AvailableTips}]";
                        }

                        fileText = $"{fileText}|{couponListText}\n";

                        filePath = Path.Combine(fileDirectory, fileNamePrefixSuccessHasCoupon);
                    }

                    setStatusStripNum();

                    FileUtils.AppendAllText(filePath, fileText, Encoding.UTF8);
                }, cancellationToken);
            }
        }

        #endregion
        #region 抽奖
        private void 抽奖ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {

                if (dgv_user.SelectedRows == null || dgv_user.SelectedRows.Count <= 0)
                {
                    UILogUtils.Error("请选择要抽奖的账号。");
                    return;
                }

                if (DateUtils.GetTimeStampOfMilliseconds() - StartTime > TimeAbnormalInterval)
                {
                    IsLoading = false;
                }
                if (IsLoading)
                {
                    return;
                }

                var iqiyiAccounts = new List<IqiyiAccount>();
                foreach (DataGridViewRow row in dgv_user.SelectedRows)
                {
                    IqiyiAccount iqiyiAccount = row.DataBoundItem as IqiyiAccount;
                    iqiyiAccounts.Add(iqiyiAccount);
                }

                IsLoading = true;

                TaskList = new List<TaskTypeEnum>{
                    TaskTypeEnum.LockDraw
                };

                TaskIndex = 0;

                lockDraw(iqiyiAccounts);
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }
        public void lockDraw(List<IqiyiAccount> iqiyiAccounts)
        {
            StartTime = DateUtils.GetTimeStampOfMilliseconds();

            SelectNum = iqiyiAccounts.Count;
            ImplementNum = 0;
            SuccessNum = 0;
            ErrorNum = 0;
            WaitNum = iqiyiAccounts.Count;
            setStatusStripNum();

            _cancellationTokenSource?.Cancel();
            _cancellationTokenSource = new CancellationTokenSource();
            CancellationToken cancellationToken = _cancellationTokenSource.Token;

            String fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志", "抽奖", DateTime.Now.ToString("yyyyMMdd"));
            String fileNamePrefixSuccess = "抽奖成功-" + DateTime.Now.ToString("HHmmss") + ".txt";
            String fileNamePrefixError = "抽奖失败-" + DateTime.Now.ToString("HHmmss") + ".txt";

            foreach (var iqiyiAccount in iqiyiAccounts)
            {
                Task.Factory.StartNew(() =>
                {
                    int threadId = Thread.CurrentThread.ManagedThreadId;
                    if (!_threadIdSet.Contains(threadId))
                    {
                        _threadIdSet.Add(threadId);
                        UILogUtils.Info($"线程[{threadId}]运行中...总线程数[{_threadIdSet.Count}]");
                    }

                    string filePath = "";
                    var lockDraw = User.LockDarw(iqiyiAccount,ActCode);

                    string fileText = $"{iqiyiAccount.MobileNo}----{iqiyiAccount.Password}----{iqiyiAccount.Cookie}";

                    if (!lockDraw.Success)
                    {
                        Interlocked.Increment(ref ErrorNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        var message = lockDraw.Msg;

                        fileText = $"{fileText}|{message}\n";
                        filePath = Path.Combine(fileDirectory, fileNamePrefixError);
                    }
                    else
                    {
                        Interlocked.Increment(ref SuccessNum);
                        Interlocked.Increment(ref ImplementNum);
                        Interlocked.Decrement(ref WaitNum);

                        var message = $"{lockDraw.Msg}";
                        if (lockDraw.Data != null && lockDraw.Data.GiftName != null)
                        {
                            message += "----" + lockDraw.Data.GiftName;
                        }
                        fileText = $"{fileText}|{message}\n";

                        filePath = Path.Combine(fileDirectory, fileNamePrefixSuccess);
                    }

                    setStatusStripNum();

                    FileUtils.AppendAllText(filePath, fileText, Encoding.UTF8);
                }, cancellationToken);
            }
        }
        #endregion
        private void Btn_start_Click(object sender, EventArgs e)
        {
            if (dgv_user.Rows.Count == 0)
            {
                UILogUtils.Info("请先导入账号");
                return;
            }

            if (DateUtils.GetTimeStampOfMilliseconds() - StartTime > TimeAbnormalInterval)
            {
                IsLoading = false;
            }
            if (IsLoading)
            {
                return;
            }

            TaskList = new List<TaskTypeEnum>();
            var taskNameList = new List<string>();
            // 执行签到
            if (cb_signIn.Checked)
            {
                TaskList.Add(TaskTypeEnum.SignIn);
                taskNameList.Add($"{EnumExtension.GetDescription(TaskTypeEnum.SignIn)}");
            }
            // 执行查询观影豆
            if (cb_movieBean.Checked)
            {
                TaskList.Add(TaskTypeEnum.MovieBean);
                taskNameList.Add($"{EnumExtension.GetDescription(TaskTypeEnum.MovieBean)}");
            }
            // 执行查询优惠券
            if (cb_coupon.Checked)
            {
                TaskList.Add(TaskTypeEnum.Coupon);
                taskNameList.Add($"{EnumExtension.GetDescription(TaskTypeEnum.Coupon)}");
            }
            // 执行抽奖
            if (cb_luckDraw.Checked)
            {

                if (ActCode.Length == 0)
                {
                    UILogUtils.Error($"请先添加抽奖Id");
                    return;
                }
                TaskList.Add(TaskTypeEnum.LockDraw);
                taskNameList.Add($"{EnumExtension.GetDescription(TaskTypeEnum.LockDraw)}");
            }

            if (TaskList.Count != 0)
            {
                if (TimerTiming.Enabled)
                {
                    SendDingdingMessagesAsync($"爱奇艺票务 即将开始执行{TaskList.Count}个任务 [{string.Join(" , ", taskNameList.ToArray())}]", "18057708086");
                }
                IsLoading = true;
                TaskIndex = 0;
                runTask();
            }
            else
            {
                UILogUtils.Error("请先选择任务类型");
                IsLoading = false;
            }
        }

         public void runTask(){
            if(TaskIndex == -1)
            {
                return;
            }
            var currentTask = TaskList[TaskIndex];

            if (TimerTiming.Enabled)
            {
                SendDingdingMessagesAsync($"爱奇艺票务 开始执行{EnumExtension.GetDescription(currentTask)}任务", "18057708086");
            }

            switch (currentTask)
            {
                case TaskTypeEnum.SignIn:
                    AccountSignIn(IqiyiAccounts);
                    break;
                case TaskTypeEnum.MovieBean:
                    queryMovieBean(IqiyiAccounts);
                    break;
                case TaskTypeEnum.Coupon:
                    queryCouponNum(IqiyiAccounts);
                    break;
                case TaskTypeEnum.LockDraw:
                    if (ActCode.Length == 0)
                    {
                        UILogUtils.Error($"请先添加抽奖Id");
                        return;
                    }
                    lockDraw(IqiyiAccounts);
                    break;
                default:
                    UILogUtils.Error($"未知任务类型");
                    break;
            }
         }

        private void Button1_Click(object sender, EventArgs e)
        {
            IsLoading = false;
            try
            {
                _cancellationTokenSource?.Cancel();
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex.ToString());
            }
        }

        private void 复制账号ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv_user.SelectedRows == null || dgv_user.SelectedRows.Count <= 0)
                {
                    UILogUtils.Error("请选择要查询的账号。");
                    return;
                }

                var iqiyiAccounts = new List<IqiyiAccount>();

                foreach (DataGridViewRow row in dgv_user.SelectedRows)
                {
                    IqiyiAccount iqiyiAccount = row.DataBoundItem as IqiyiAccount;
                    iqiyiAccounts.Add(iqiyiAccount);
                }

                copyAccountInfo(iqiyiAccounts);
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }
        private void copyAccountInfo(List<IqiyiAccount> iqiyiAccounts)
        {

            StringBuilder stringBuilder = new StringBuilder();

            foreach (var iqiyiAccount in iqiyiAccounts)
            {
                stringBuilder.AppendLine($"{iqiyiAccount.MobileNo}----{iqiyiAccount.Password}----{iqiyiAccount.Cookie}");
            }

            Clipboard.SetText(stringBuilder.ToString());

            UILogUtils.Info("复制账号成功。");
        }

        private void 导出账号ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if(dgv_user.Rows.Count == 0)
            {
                UILogUtils.Info($"请先导入账号");
                return;
            }

            var iqiyiAccounts = new List<IqiyiAccount>();
            foreach(DataGridViewRow row in dgv_user.Rows)
            {
                IqiyiAccount iqiyiAccount = row.DataBoundItem as IqiyiAccount;
                iqiyiAccounts.Add(iqiyiAccount);
            }

            copyAccountInfo(iqiyiAccounts);
        }

        private void 清空账号ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            dgv_user.DataSource = null;
            IqiyiAccounts = new List<IqiyiAccount>();
        }

        private void 删除ToolStripMenuItem_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv_user.SelectedRows == null || dgv_user.SelectedRows.Count <= 0)
                {
                    UILogUtils.Error("请选择要删除的账号。");
                    return;
                }

                IList list = (IList)dgv_user.DataSource;
                var newList = new List<IqiyiAccount>();
                for (int j = 0; j < list.Count; j++)
                {
                    var item = list[j] as IqiyiAccount;
                    var isHas = false;
                    foreach (DataGridViewRow row in dgv_user.SelectedRows)
                    {
                        IqiyiAccount selectItem = row.DataBoundItem as IqiyiAccount;

                        if ( selectItem.MobileNo == item.MobileNo)
                        {
                            isHas = true;
                        }
                    }
                    if (!isHas)
                    {
                        newList.Add(item);
                    }
                }
                dgv_user.DataSource = null; //为空
                dgv_user.DataSource = newList; //显示数据

                UILogUtils.Info("删除账号成功。");
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex);
            }
        }

        private void Button2_Click(object sender, EventArgs e)
        {
            try
            {
                String fileDirectory = "";
                if (cb_signIn.Checked)
                {
                    fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志", "签到", DateTime.Now.ToString("yyyyMMdd"));
                }
                else if (cb_movieBean.Checked)
                {
                    fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志", "查询观影豆", DateTime.Now.ToString("yyyyMMdd"));
                }
                else if (cb_coupon.Checked)
                {
                    fileDirectory = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "日志","查询优惠券", DateTime.Now.ToString("yyyyMMdd"));
                }

                if (!Directory.Exists(fileDirectory))
                {
                    UILogUtils.Error("文件夹不存在。" + fileDirectory);
                    return;
                }
                System.Diagnostics.Process.Start("explorer.exe", fileDirectory);
            }
            catch (Exception ex)
            {
                UILogUtils.Error(ex.ToString());
            }
        }

        private void Btn_set_interval_Click(object sender, EventArgs e)
        {
            var setInterval = new SetInterval();
            setInterval.ShowDialog(this);
        }
        /// <summary>
        /// 设置定时任务的回调任务
        /// </summary>
        /// <param name="type">操作类型</param>0 -> 启动; 1 -> 关闭
        /// <param name="timeNum"></param>
        public void SetIntervalBack(int type ,int timeNum)
        {
            TimerSetOnTime.Stop();
            TimerSetOnTime.Dispose();
            TimerTiming.Stop();
            TimerTiming.Dispose();

            if (type == 0)
            {
                tssl_timer_status.BackColor = Color.ForestGreen;
                tssl_timer_status.ForeColor = Color.White;

                IntervalTime = timeNum;

                setTimer();
            }
            else if( type == 1)
            {
                tssl_timer_status.BackColor = Color.LightCoral;
                tssl_timer_status.ForeColor = Color.Black;
            }
        }
        public void setTimer()
        {
            var intervalTime = IntervalTime;
            var currentHour = DateTime.Now.Hour;
            var currentMinute = DateTime.Now.Minute;
            var currentSecond = DateTime.Now.Second;

            var currentTime = currentHour * 60 * 60 + currentMinute * 60 + currentSecond;

            var timeDifference = 0;
            if (currentTime > intervalTime)
            {
                timeDifference = 24 * 60 * 60 - (currentTime - intervalTime);
            }
            else
            {
                timeDifference = intervalTime - currentTime;
            }
            
            var logText = $"任务将在{Convert.ToInt32(timeDifference / (60 * 60))}小时{Convert.ToInt32((timeDifference % (60 * 60)) / 60)}分钟{timeDifference % 60}秒钟后开始执行";

            UILogUtils.Info(logText);

            TimerSetOnTime.Interval = 1000 * (timeDifference);

            TimerSetOnTime.Tick += new EventHandler((s, e) =>
            {
                UILogUtils.Info("准备开始设置每天定时任务");
                TimerSetOnTime.Stop();
                TimerSetOnTime.Dispose();
                setTiming();
            });

            TimerSetOnTime.Start();
        }
        public void setTiming()
        {
            TimerTiming.Stop();
            TimerTiming.Dispose();
            // TODO 缩短执行时间
            TimerTiming.Interval = 1000 * 60 * 60 * 24;
            // TimerTiming.Interval = 1000 * 10;

            TimerTiming.Tick += new EventHandler((s, e) =>
            {
                UILogUtils.Info("开始执行定时任务");
                Btn_start_Click(new object(), new EventArgs());
            });

            TimerTiming.Start();

            Btn_start_Click(new object(), new EventArgs());
        }

        public void SetActCode(int type , string actCode) 
        {
            if(type == 0)
            {
                ActCode = actCode;
                UILogUtils.Info($"设置抽奖Id成功; [{ActCode}]");
            }
        }

        private static void SendDingdingMessagesAsync(string message, string mobile)
        {
            UILogUtils.Info($"发送钉钉消息：[{message}] - [{mobile}]");
            if (message != null)
            {
                message = "[千猪]" + message;
            }
            Task.Factory.StartNew(() =>
            {
                var atMobiles = new List<string>();
                atMobiles.Add(mobile);
                DingDingClient.SendMessage(DingDingConstant.WEB_HOOK_URL, message, atMobiles);
            });
        }

        private void Button3_Click(object sender, EventArgs e)
        {
            var setLuckDraw = new SetLuckDraw();
            setLuckDraw.ShowDialog(this);
        }

    }
}
