﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;

namespace iqiyiWin.Response.User.CouponList
{
    public class CouponListResponse
    {
        /// <summary>
        /// Examples: {"valid":[{"jumpType":"giftpackets","displaySubName":"","disCount":300.0,"availableTips":"有效期至 2021.04.24","jumpParam":"","tipTags":["限购超值礼包","不可叠加"],"displayName":"超值礼包抵扣券（新人专享）","isGiftPackage":false,"disCountStr":"3","withPriceChange":false,"showUse":true,"bossTicket":"221B-GZWW-ZBFN-U3R4-GRGJ","displaySubType":"限购超值礼包","couponType":1,"giftPackageH5Url":"https://app.iqiyi.com/ext/common/qipiao/libao_goumai/app.html?channel=piaoh5_lbkq","withPriceChangeTip":"不可叠加","desc":"仅限爱奇艺票务APP使用；\r\n仅限购买超值礼包产品抵扣使用。"}],"invalid":[{"reason":"已使用","displaySubName":"满50元可用","disCount":800.0,"availableTips":"有效期至 2021.03.01","tipTags":["限购电影票","满50元可用","不可叠加"],"displayName":"8元电影优惠券","isGiftPackage":false,"disCountStr":"8","withPriceChange":false,"showUse":false,"bossTicket":"4ZWH-NXVR-MBFS-T3X6-NG6U","displaySubType":"限购电影票","invalidReasonType":1,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满50元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.13","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"426A-Z7G8-CBFX-7K35-EYBK","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满28元可用","disCount":500.0,"availableTips":"有效期至 2021.02.08","tipTags":["限购电影票","满28元可用","不可叠加"],"displayName":"电影票代金券（新人专享）","isGiftPackage":false,"disCountStr":"5","withPriceChange":false,"showUse":false,"bossTicket":"323R-CVE2-BBFN-U3R4-V38D","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"仅限爱奇艺票务APP内使用；\r\n单笔订单满28元可用，可与改价优惠活动叠加使用，支持的影院以实际可用为准；"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.07","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"226A-ZFE3-RBFT-LMB3-X71K","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.03","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"426A-ZCS7-5BFQ-SYTL-RDFF","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.02","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"426A-ZLYA-8BFQ-7VBF-S4FP","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.01","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"323S-T4C9-8BFP-EQRI-XFAV","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.01.31","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"226A-Z4WM-MBFP-41CA-DJY5","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.01.31","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"523S-T4LK-8BFN-UAKP-TTDC","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"}]}
        /// </summary>
        [JsonProperty("data")]
        public Data Data { get; set; }

        /// <summary>
        /// Examples: "20210223185905"
        /// </summary>
        [JsonProperty("timestamp")]
        public string Timestamp { get; set; }

        /// <summary>
        /// Examples: "A00000"
        /// </summary>
        [JsonProperty("code")]
        public string Code { get; set; }

        /// <summary>
        /// Examples: "1311325e-3873-48d4-81bd-c0db55ed5538"
        /// </summary>
        [JsonProperty("requestId")]
        public string RequestId { get; set; }

        /// <summary>
        /// Examples: ""
        /// </summary>
        [JsonProperty("msg")]
        public string Msg { get; set; }

        /// <summary>
        /// Examples: false
        /// </summary>
        [JsonProperty("hasNext")]
        public bool HasNext { get; set; }
    }
    public class Data
    {

        /// <summary>
        /// Examples: [{"jumpType":"giftpackets","displaySubName":"","disCount":300.0,"availableTips":"有效期至 2021.04.24","jumpParam":"","tipTags":["限购超值礼包","不可叠加"],"displayName":"超值礼包抵扣券（新人专享）","isGiftPackage":false,"disCountStr":"3","withPriceChange":false,"showUse":true,"bossTicket":"221B-GZWW-ZBFN-U3R4-GRGJ","displaySubType":"限购超值礼包","couponType":1,"giftPackageH5Url":"https://app.iqiyi.com/ext/common/qipiao/libao_goumai/app.html?channel=piaoh5_lbkq","withPriceChangeTip":"不可叠加","desc":"仅限爱奇艺票务APP使用；\r\n仅限购买超值礼包产品抵扣使用。"}]
        /// </summary>
        [JsonProperty("valid")]
        public List<Valid> Valid { get; set; }

        /// <summary>
        /// Examples: [{"reason":"已使用","displaySubName":"满50元可用","disCount":800.0,"availableTips":"有效期至 2021.03.01","tipTags":["限购电影票","满50元可用","不可叠加"],"displayName":"8元电影优惠券","isGiftPackage":false,"disCountStr":"8","withPriceChange":false,"showUse":false,"bossTicket":"4ZWH-NXVR-MBFS-T3X6-NG6U","displaySubType":"限购电影票","invalidReasonType":1,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满50元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.13","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"426A-Z7G8-CBFX-7K35-EYBK","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满28元可用","disCount":500.0,"availableTips":"有效期至 2021.02.08","tipTags":["限购电影票","满28元可用","不可叠加"],"displayName":"电影票代金券（新人专享）","isGiftPackage":false,"disCountStr":"5","withPriceChange":false,"showUse":false,"bossTicket":"323R-CVE2-BBFN-U3R4-V38D","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"仅限爱奇艺票务APP内使用；\r\n单笔订单满28元可用，可与改价优惠活动叠加使用，支持的影院以实际可用为准；"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.07","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"226A-ZFE3-RBFT-LMB3-X71K","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.03","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"426A-ZCS7-5BFQ-SYTL-RDFF","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.02","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"426A-ZLYA-8BFQ-7VBF-S4FP","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.02.01","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"323S-T4C9-8BFP-EQRI-XFAV","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.01.31","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"签到奖品-电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"226A-Z4WM-MBFP-41CA-DJY5","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"},{"reason":"已过期","displaySubName":"满35元可用","disCount":200.0,"availableTips":"有效期至 2021.01.31","tipTags":["限购电影票","满35元可用","不可叠加"],"displayName":"电影票代金券","isGiftPackage":false,"disCountStr":"2","withPriceChange":false,"showUse":false,"bossTicket":"523S-T4LK-8BFN-UAKP-TTDC","displaySubType":"限购电影票","invalidReasonType":2,"couponType":1,"withPriceChangeTip":"不可叠加","desc":"单笔订单满35元可用；\r\n不可与其他优惠同享。"}]
        /// </summary>
        [JsonProperty("invalid")]
        public List<Invalid> Invalid { get; set; }
    }
    public class Invalid
    {

        /// <summary>
        /// Examples: "已使用", "已过期"
        /// </summary>
        [JsonProperty("reason")]
        public string Reason { get; set; }

        /// <summary>
        /// Examples: "满50元可用", "满35元可用", "满28元可用"
        /// </summary>
        [JsonProperty("displaySubName")]
        public string DisplaySubName { get; set; }

        /// <summary>
        /// Examples: 800.0, 200.0, 500.0
        /// </summary>
        [JsonProperty("disCount")]
        public double DisCount { get; set; }

        /// <summary>
        /// Examples: "有效期至 2021.03.01", "有效期至 2021.02.13", "有效期至 2021.02.08", "有效期至 2021.02.07", "有效期至 2021.02.03"
        /// </summary>
        [JsonProperty("availableTips")]
        public string AvailableTips { get; set; }

        /// <summary>
        /// Examples: ["限购电影票","满50元可用","不可叠加"], ["限购电影票","满35元可用","不可叠加"], ["限购电影票","满28元可用","不可叠加"], ["限购电影票","满35元可用","不可叠加"], ["限购电影票","满35元可用","不可叠加"]
        /// </summary>
        [JsonProperty("tipTags")]
        public List<string> TipTags { get; set; }

        /// <summary>
        /// Examples: "8元电影优惠券", "签到奖品-电影票代金券", "电影票代金券（新人专享）", "电影票代金券"
        /// </summary>
        [JsonProperty("displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Examples: false
        /// </summary>
        [JsonProperty("isGiftPackage")]
        public bool IsGiftPackage { get; set; }

        /// <summary>
        /// Examples: "8", "2", "5"
        /// </summary>
        [JsonProperty("disCountStr")]
        public string DisCountStr { get; set; }

        /// <summary>
        /// Examples: false
        /// </summary>
        [JsonProperty("withPriceChange")]
        public bool WithPriceChange { get; set; }

        /// <summary>
        /// Examples: false
        /// </summary>
        [JsonProperty("showUse")]
        public bool ShowUse { get; set; }

        /// <summary>
        /// Examples: "4ZWH-NXVR-MBFS-T3X6-NG6U", "426A-Z7G8-CBFX-7K35-EYBK", "323R-CVE2-BBFN-U3R4-V38D", "226A-ZFE3-RBFT-LMB3-X71K", "426A-ZCS7-5BFQ-SYTL-RDFF"
        /// </summary>
        [JsonProperty("bossTicket")]
        public string BossTicket { get; set; }

        /// <summary>
        /// Examples: "限购电影票"
        /// </summary>
        [JsonProperty("displaySubType")]
        public string DisplaySubType { get; set; }

        /// <summary>
        /// Examples: 1, 2
        /// </summary>
        [JsonProperty("invalidReasonType")]
        public int InvalidReasonType { get; set; }

        /// <summary>
        /// Examples: 1
        /// </summary>
        [JsonProperty("couponType")]
        public int CouponType { get; set; }

        /// <summary>
        /// Examples: "不可叠加"
        /// </summary>
        [JsonProperty("withPriceChangeTip")]
        public string WithPriceChangeTip { get; set; }

        /// <summary>
        /// Examples: "单笔订单满50元可用；\r\n不可与其他优惠同享。", "单笔订单满35元可用；\r\n不可与其他优惠同享。", "仅限爱奇艺票务APP内使用；\r\n单笔订单满28元可用，可与改价优惠活动叠加使用，支持的影院以实际可用为准；"
        /// </summary>
        [JsonProperty("desc")]
        public string Desc { get; set; }
    }
    public class Valid
    {

        /// <summary>
        /// Examples: "giftpackets"
        /// </summary>
        [JsonProperty("jumpType")]
        public string JumpType { get; set; }

        /// <summary>
        /// Examples: ""
        /// </summary>
        [JsonProperty("displaySubName")]
        public string DisplaySubName { get; set; }

        /// <summary>
        /// Examples: 300.0
        /// </summary>
        [JsonProperty("disCount")]
        public double DisCount { get; set; }

        /// <summary>
        /// Examples: "有效期至 2021.04.24"
        /// </summary>
        [JsonProperty("availableTips")]
        public string AvailableTips { get; set; }

        /// <summary>
        /// Examples: ""
        /// </summary>
        [JsonProperty("jumpParam")]
        public string JumpParam { get; set; }

        /// <summary>
        /// Examples: ["限购超值礼包","不可叠加"]
        /// </summary>
        [JsonProperty("tipTags")]
        public IList<string> TipTags { get; set; }

        /// <summary>
        /// Examples: "超值礼包抵扣券（新人专享）"
        /// </summary>
        [JsonProperty("displayName")]
        public string DisplayName { get; set; }

        /// <summary>
        /// Examples: false
        /// </summary>
        [JsonProperty("isGiftPackage")]
        public bool IsGiftPackage { get; set; }

        /// <summary>
        /// Examples: "3"
        /// </summary>
        [JsonProperty("disCountStr")]
        public string DisCountStr { get; set; }

        /// <summary>
        /// Examples: false
        /// </summary>
        [JsonProperty("withPriceChange")]
        public bool WithPriceChange { get; set; }

        /// <summary>
        /// Examples: true
        /// </summary>
        [JsonProperty("showUse")]
        public bool ShowUse { get; set; }

        /// <summary>
        /// Examples: "221B-GZWW-ZBFN-U3R4-GRGJ"
        /// </summary>
        [JsonProperty("bossTicket")]
        public string BossTicket { get; set; }

        /// <summary>
        /// Examples: "限购超值礼包"
        /// </summary>
        [JsonProperty("displaySubType")]
        public string DisplaySubType { get; set; }

        /// <summary>
        /// Examples: 1
        /// </summary>
        [JsonProperty("couponType")]
        public int CouponType { get; set; }

        /// <summary>
        /// Examples: "3天到期"
        /// </summary>
        [JsonProperty("expiredTimeRemind")]
        public string ExpiredTimeRemind { get; set; }

        /// <summary>
        /// Examples: "https://app.iqiyi.com/ext/common/qipiao/libao_goumai/app.html?channel=piaoh5_lbkq"
        /// </summary>
        [JsonProperty("giftPackageH5Url")]
        public string GiftPackageH5Url { get; set; }


        /// <summary>
        /// Examples: "不可叠加"
        /// </summary>
        [JsonProperty("withPriceChangeTip")]
        public string WithPriceChangeTip { get; set; }

        /// <summary>
        /// Examples: "仅限爱奇艺票务APP使用；\r\n仅限购买超值礼包产品抵扣使用。"
        /// </summary>
        [JsonProperty("desc")]
        public string Desc { get; set; }

        
        public int ExpiredTimeNum { get { return Convert.ToInt32(System.Text.RegularExpressions.Regex.Replace(ExpiredTimeRemind, @"[^0-9]+", "")); } }
    }
}
