﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;

namespace iqiyiWin.Response.User.MovieBean
{
    public class MovieBeanResponse
    {/// <summary>
     /// Examples: 状态码
     /// </summary>
        [JsonProperty("code")]
        public string Code { get; set; }

        /// <summary>
        /// Examples: 时间戳
        /// </summary>
        [JsonProperty("timeStamp")]
        public string TimeStamp { get; set; }

        /// <summary>
        /// Examples: 消息
        /// </summary>
        [JsonProperty("msg")]
        public string Msg { get; set; }

        /// <summary>
        /// Examples: {"records":[{"date":"2021-02-22 17:36","count":25.0,"entityId":0,"title":"完成新手任务: 首次体验在线选座"},{"date":"2021-02-22 17:03","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-02-22 11:32","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-02-21 20:01","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-02-20 20:33","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-02-19 12:50","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-02-18 23:10","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-02-17 18:19","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-02-16 12:09","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-02-15 18:50","count":75.0,"entityId":3409592097,"title":"购买电影《熊出没·狂野大陆》"},{"date":"2021-02-15 15:34","count":-200.0,"entityId":3409592097,"title":"购票抵现金-订单号3409592097"},{"date":"2021-02-15 15:34","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-02-14 10:24","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-02-13 22:29","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-02-12 18:26","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-02-11 11:06","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-02-10 00:20","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-02-09 00:21","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-02-09 00:03","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-02-07 10:28","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-02-06 00:21","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-02-05 00:20","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-02-04 02:23","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-02-03 00:24","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-02-02 01:08","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-02-02 00:33","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-02-01 09:56","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-01-31 10:24","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-01-30 16:22","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-01-29 10:22","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-01-28 21:47","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-01-28 15:18","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-01-27 11:07","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-01-26 10:10","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-01-26 00:10","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-01-25 10:10","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-01-24 13:08","count":1.0,"entityId":0,"title":"签到"}],"balanceCount":395.0,"linkUrl":"qyticket://qymweb?needLogin=1&url=https%3A%2F%2Fact.iqiyi.com%2Fact%2Fpages%2Fnewbie_task%2Fapp.html"}
        /// </summary>
        [JsonProperty("data")]
        public Data Data { get; set; }
    }
    public class Data
    {

        /// <summary>
        /// Examples: [{"date":"2021-02-22 17:36","count":25.0,"entityId":0,"title":"完成新手任务: 首次体验在线选座"},{"date":"2021-02-22 17:03","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-02-22 11:32","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-02-21 20:01","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-02-20 20:33","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-02-19 12:50","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-02-18 23:10","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-02-17 18:19","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-02-16 12:09","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-02-15 18:50","count":75.0,"entityId":3409592097,"title":"购买电影《熊出没·狂野大陆》"},{"date":"2021-02-15 15:34","count":-200.0,"entityId":3409592097,"title":"购票抵现金-订单号3409592097"},{"date":"2021-02-15 15:34","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-02-14 10:24","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-02-13 22:29","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-02-12 18:26","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-02-11 11:06","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-02-10 00:20","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-02-09 00:21","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-02-09 00:03","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-02-07 10:28","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-02-06 00:21","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-02-05 00:20","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-02-04 02:23","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-02-03 00:24","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-02-02 01:08","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-02-02 00:33","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-02-01 09:56","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-01-31 10:24","count":1.0,"entityId":0,"title":"签到"},{"date":"2021-01-30 16:22","count":100.0,"entityId":0,"title":"签到"},{"date":"2021-01-29 10:22","count":6.0,"entityId":0,"title":"签到"},{"date":"2021-01-28 21:47","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-01-28 15:18","count":5.0,"entityId":0,"title":"签到"},{"date":"2021-01-27 11:07","count":4.0,"entityId":0,"title":"签到"},{"date":"2021-01-26 10:10","count":3.0,"entityId":0,"title":"签到"},{"date":"2021-01-26 00:10","count":2.0,"entityId":0,"title":"幸运抽奖奖品 +2观影豆"},{"date":"2021-01-25 10:10","count":2.0,"entityId":0,"title":"签到"},{"date":"2021-01-24 13:08","count":1.0,"entityId":0,"title":"签到"}]
        /// </summary>
        [JsonProperty("records")]
        public IList<Record> Records { get; set; }

        /// <summary>
        /// Examples: 395.0
        /// </summary>
        [JsonProperty("balanceCount")]
        public double BalanceCount { get; set; }

        /// <summary>
        /// Examples: "qyticket://qymweb?needLogin=1&url=https%3A%2F%2Fact.iqiyi.com%2Fact%2Fpages%2Fnewbie_task%2Fapp.html"
        /// </summary>
        [JsonProperty("linkUrl")]
        public string LinkUrl { get; set; }
    }
    public class Record
    {

        /// <summary>
        /// Examples: "2021-02-22 17:36", "2021-02-22 17:03", "2021-02-22 11:32", "2021-02-21 20:01", "2021-02-20 20:33"
        /// </summary>
        [JsonProperty("date")]
        public string Date { get; set; }

        /// <summary>
        /// Examples: 25.0, 2.0, 100.0, 6.0, 5.0
        /// </summary>
        [JsonProperty("count")]
        public double Count { get; set; }

        /// <summary>
        /// Examples: 0, 3409592097
        /// </summary>
        [JsonProperty("entityId")]
        public object EntityId { get; set; }

        /// <summary>
        /// Examples: "完成新手任务: 首次体验在线选座", "幸运抽奖奖品 +2观影豆", "签到", "购买电影《熊出没·狂野大陆》", "购票抵现金-订单号3409592097"
        /// </summary>
        [JsonProperty("title")]
        public string Title { get; set; }
    }
}
