﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace iqiyiWin
{
    public partial class SetInterval : Form
    {
        public SetInterval()
        {
            InitializeComponent();
            init();
        }
        private void init()
        {
            var intervalTime = Main._this.IntervalTime;

            var hour = Convert.ToInt32(intervalTime / (60*60));
            var minute = Convert.ToInt32((intervalTime % (60 * 60))/60);
            var second = Convert.ToInt32(intervalTime % 60);

            tb_set_interval.Text = $"{repairZero(hour)}:{repairZero(minute)}:{repairZero(second)}";
        }
        private string repairZero(int num)
        {
            return num < 10 ? ("0" + num) : num.ToString();
        }
        private void Button1_Click(object sender, EventArgs e)
        {
            var time = tb_set_interval.Text;
            var timeList = time.Split(new char[] { ':' });
            if (timeList.Length != 3 || time.Length != 8)
            {
                MessageBox.Show($"请输入正确的时间格式");
                return;
            }

            var hour = Convert.ToInt32(timeList[0]);
            var minute = Convert.ToInt32(timeList[1]);
            var second = Convert.ToInt32(timeList[2]);
            var timeDifference = hour * 60 * 60 + minute * 60 + second;

            Main._this.SetIntervalBack(0,timeDifference);

            this.Close();
        }

        private void Btn_stop_Click(object sender, EventArgs e)
        {
            Main._this.SetIntervalBack(1,0);

            this.Close();
        }
    }
}
