﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace iqiyiWin.Util
{
    public class FileUtils
    {
        private static ConcurrentDictionary<string, object> ConcurrentDictionary = new ConcurrentDictionary<string, object>();

        public static void AppendAllText(String path, String contents)
        {
            var syncObj = ConcurrentDictionary.GetOrAdd(path, new Object());
            lock (syncObj)
            {
                FileInfo file = new FileInfo(path);
                if (!Directory.Exists(file.DirectoryName))
                {
                    Directory.CreateDirectory(file.DirectoryName);
                }
                File.AppendAllText(path, contents);
            }
        }

        public static void AppendAllText(String path, String contents, Encoding encoding)
        {
            var syncObj = ConcurrentDictionary.GetOrAdd(path, new Object());
            lock (syncObj)
            {
                FileInfo file = new FileInfo(path);
                if (!Directory.Exists(file.DirectoryName))
                {
                    Directory.CreateDirectory(file.DirectoryName);
                }

                File.AppendAllText(path, contents, encoding);
            }
        }

        public static void AppendAllLines(String path, IEnumerable<string> contents)
        {
            var syncObj = ConcurrentDictionary.GetOrAdd(path, new Object());
            lock (syncObj)
            {
                FileInfo file = new FileInfo(path);
                if (!Directory.Exists(file.DirectoryName))
                {
                    Directory.CreateDirectory(file.DirectoryName);
                }
                File.AppendAllLines(path, contents);
            }
        }

        public static void AppendAllLines(String path, IEnumerable<string> contents, Encoding encoding)
        {
            var syncObj = ConcurrentDictionary.GetOrAdd(path, new Object());
            lock (syncObj)
            {
                FileInfo file = new FileInfo(path);
                if (!Directory.Exists(file.DirectoryName))
                {
                    Directory.CreateDirectory(file.DirectoryName);
                }
                File.AppendAllLines(path, contents, encoding);
            }
        }
    }
}
