﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Text;
using System.Threading.Tasks;

namespace iqiyiWin.Util
{
    public class HttpUtils
    {
        /// <summary>
        /// GET
        /// </summary>
        /// <param name="url">url</param>
        /// <param name="timeout">请求超时前等待的毫秒数。</param>
        /// <returns>response</returns>
        public static string DoGet(string url, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Method = "GET";
            request.Timeout = timeout;

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();

                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string result = streamReader.ReadToEnd();

                return result;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }

        /// <summary>
        /// GET
        /// </summary>
        /// <param name="url">url</param>
        /// <param name="timeout">请求超时前等待的毫秒数。</param>
        /// <returns>response</returns>
        public static HttpResult DoGetResult(string url, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Method = "GET";
            request.Timeout = timeout;

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();

                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string result = streamReader.ReadToEnd();

                HttpResult httpResult = new HttpResult()
                {
                    Body = result,
                    Headers = response.Headers
                };
                return httpResult;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }

        /// <summary>
        /// GET
        /// </summary>
        /// <param name="url">url</param>
        /// <param name="timeout">请求超时前等待的毫秒数。</param>
        /// <returns>response</returns>
        public static string DoGet(CookieContainer cookieContainer, string url, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Referer = "https://movie.iqiyi.com/";
            request.Method = "GET";
            request.Timeout = timeout;

            request.CookieContainer = cookieContainer;

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();

                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string result = streamReader.ReadToEnd();

                return result;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }

        public static string DoGet(CookieContainer cookieContainer, string referer, string url, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Referer = referer;
            request.Method = "GET";
            request.Timeout = timeout;

            request.CookieContainer = cookieContainer;

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();

                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string result = streamReader.ReadToEnd();

                return result;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }

        public static string DoPost(string url, string data, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Method = "POST";
            request.ContentType = JsonUtils.IsJsonData(data) ? "application/json" : "application/x-www-form-urlencoded";

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }
            if (!string.IsNullOrEmpty(data))
            {
                Stream requestStream = request.GetRequestStream();
                byte[] bytes = Encoding.UTF8.GetBytes(data);
                requestStream.Write(bytes, 0, bytes.Length);
                requestStream.Close();
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string result = streamReader.ReadToEnd();

                return result;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }


        public static HttpResult DoPostResult(string url, string data, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Method = "POST";
            request.ContentType = JsonUtils.IsJsonData(data) ? "application/json" : "application/x-www-form-urlencoded";

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }
            if (!string.IsNullOrEmpty(data))
            {
                Stream requestStream = request.GetRequestStream();
                byte[] bytes = Encoding.UTF8.GetBytes(data);
                requestStream.Write(bytes, 0, bytes.Length);
                requestStream.Close();
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();
                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);
                string result = streamReader.ReadToEnd();

                HttpResult httpResult = new HttpResult()
                {
                    Body = result,
                    Headers = response.Headers
                };
                return httpResult;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }

        public static string DoPost(CookieContainer cookieContainer, string url, string data, IDictionary<string, string> headers, int timeout = 10000)
        {
            HttpWebRequest request = (HttpWebRequest)WebRequest.Create(url);
            request.Method = "POST";
            request.ContentType = JsonUtils.IsJsonData(data) ? "application/json" : "application/x-www-form-urlencoded";
            request.CookieContainer = cookieContainer;

            if (headers != null)
            {
                foreach (var header in headers)
                {
                    if (header.Key.Equals("User-Agent"))
                    {
                        request.UserAgent = header.Value;
                        continue;
                    }
                    request.Headers.Add(header.Key, header.Value);
                }
            }
            if (!string.IsNullOrEmpty(data))
            {
                Stream requestStream = request.GetRequestStream();
                byte[] bytes = Encoding.UTF8.GetBytes(data);
                requestStream.Write(bytes, 0, bytes.Length);
                requestStream.Close();
            }

            Stream responseStream = null;
            StreamReader streamReader = null;
            try
            {
                HttpWebResponse response = (HttpWebResponse)request.GetResponse();

                responseStream = response.GetResponseStream();
                streamReader = new StreamReader(responseStream, Encoding.UTF8);

                string result = streamReader.ReadToEnd();
                return result;
            }
            finally
            {
                streamReader?.Close();
                responseStream?.Close();
            }
        }


    }
}

